# Yield extraction

extract_ags_yield <- function(pre = 30, post = 90, open_window = 60){
  
  yield_data <- import_yield_curve_data()
  
  yield_data_extracted <- data_window_extract(yield_data, rbatools::board_times()$decision_datetime,
                                              pre = pre, post = post, open_window = open_window) %>% 
    filter(!is.na(yield))
  
  
  yield_metadata <- yield_data_extracted %>%  add_bond_metadata()
  
  return(yield_metadata)
}

# OIS extraction
extract_ois <- function(pre = 30, post = 90, open_window = 60){
  ois_changes <- import_ois_all() %>% 
    data_window_extract(., rbatools::board_times()$decision_datetime, pre = pre, post = post, open_window = open_window)
  return(ois_changes)
}
